/*! Custom */
$(function() {
	
	var core = {
		init: function() {
            this.pkwliste()
        },
		pkwliste: function() {
			$(".ergbn-mdlw input").prop('checked', false);
			$(".ergbn-mdlw").removeClass("active");
			$("#fid").val("");
			$("#hsntab").on("keyup", function(e) {
				if (this.value.length == this.maxLength) {
				  $('#tsntab').focus();
				}
			});
			$('body').on('keyup','.pkwliste_suche_inp.hersteller', function(e){
				var value = $(this).val().toLowerCase();
				$("#herst_ol_list li").filter(function() {
					var suchinput = $(this).data("suche").toString().toLowerCase();
					$(this).toggle(suchinput.indexOf(value) > -1)
				});
			});
			$('body').on('keyup','.pkwliste_suche_inp.baureihe', function(e){				
				var value = $(this).val().toLowerCase();
				$("#baureihen_ol_list li").filter(function() {
					var suchinput = $(this).data("suche").toString().toLowerCase();
					$(this).toggle(suchinput.indexOf(value) > -1)
				});				
			});
			$('body').on('keyup','#pkw_modellwahl', function(e){
				var value = $(this).val().toLowerCase();
				$(".ergebnisse-tabelle > tbody > tr").filter(function() {
					
					$(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
				});
			});
			$('body').on('click','.ergbn-mdlw', function(e){
				$(".ergbn-mdlw").removeClass("active");
				$(".ergbn-mdlw input").prop('checked', false);
				$(this).addClass("active");
				$(this).find('input').prop('checked', true);
				$(".fehlermeldung").fadeOut();
				var fid = $(this).data("fid");
				$("#fid").val(fid);
			});
			$('body').on('submit','#go_to_fahrz', function(e){
				e.preventDefault();
				var fid = $("#fid").val();
				var url = $(this).attr("action");
				if(fid == "") {
					$(".fehlermeldung").show();
					e.preventDefault();
				}
				else {
					window.open(url+'?id='+fid, '_self');
				}
			});
			$('body').on('submit','#go_to_hsn_tsn', function(e){
				e.preventDefault();
				var hsn = $("#hsntab").val();
				var tsn = $("#tsntab").val();
				var url = $(this).attr("action");
				if(hsn == "" || tsn == "") {
					$("#pkw_e_hsn_tsn").html("Schlüsselnummer fehlt").show();
					e.preventDefault();
				}
				else {
					$.ajax({
						url: 'api/?daten=fahrzeugdaten&hsn='+hsn+'&tsn='+tsn,
						type: 'GET',
						dataType: 'JSON',
						beforeSend: function() {
						var loader = "<div id=\"list_loader\"><i class=\"fa fa-spinner fa-spin fa-3x fa-fw\"></i><span class=\"sr-only\">Loading...</span><br /><br /><span>Wird geladen...</span></div>";
							$("#go_to_hsn_tsn").hide();
							$("#hsn_tsn_form").append(loader);
						},
						success: function(data){
							if(data.status == "200") {
								window.open(url+'?id='+data.fahrzeugdaten[0].fahrzeug_id, '_self');
							}
							else {
								var fehlertext = "Ihre Suche ergab 0 Treffer";
								$("#go_to_hsn_tsn").show();
								$("#list_loader").remove();
								$("#hsntab").val('');
								$("#tsntab").val('');
								$("#pkw_e_hsn_tsn").html(fehlertext).show();
								console.log(data.nachricht);
							}
						}
					});					
				}
			});
			$.ajax({
				url: 'api/?daten=hersteller',
				type: 'GET',
				dataType: 'JSON',
				success: function(data){
					if(data.status == "200") {
						var li = "";
						$.each(data.hersteller, function (index, value) {
							li += "<li class=\"gz_bs\" data-suche=\""+value.hersteller_name+"\" data-hid=\""+value.hersteller_id+"\"><img class=\"hersteller-logo\" src=\"img/pkwliste/hersteller/"+value.hersteller_id+".png\" alt=\""+value.hersteller_name+"\" />"+value.hersteller_name+"</li>";
						});
						$("#herst_ol_list").html(li);
					}
					else {
						console.log(data.nachricht);
					}					
				}
			});
			$('body').on('click','.top-5', function(e){
				var id_marke = $(this).data('hid');
				$.ajax({
					url: 'api/?daten=modelle&id='+id_marke,
					type: 'GET',
					dataType: 'JSON',
					beforeSend: function() {
						var loader = "<div id=\"list_loader\"><i class=\"fa fa-spinner fa-spin fa-3x fa-fw\"></i><span class=\"sr-only\">Loading...</span><br /><br /><span>Wird geladen...</span></div>";
						$("#herst_ol_list").html(loader);
					},
					success: function(data){
						if(data.status == "200") {
							var li = "";
							$.each(data.modelle, function (index, value) {
								li += "<li class=\"gz_gr\" data-mid=\""+value.modell_id+"\" data-suche=\""+value.modell_name+"\"><img class=\"hersteller-logo\" src=\"img/pkwliste/hersteller/"+value.hersteller_id+".png\" alt=\""+value.hersteller_name+"\" />"+value.modell_name+"</li>";
							});
							$("#baureihen_ol_list").html(li);
							$("#herst_ol_list").hide();
							$("#sawl").hide();
							$("#aswn").show();
							$("#baureihen_ol_list").show();
							$(".pkwliste_suche_inp").removeClass().addClass("pkwliste_suche_inp baureihe");
							$(".pkwliste_suche_inp").attr('placeholder', 'Modell');
							$(".pkwliste_suche_inp").val('');
						}
						else {
							console.log(data.nachricht);
						}
					}
				});	
			});
			$('body').on('click','#go_back_an, #erg_s_z, #tab_l_1', function(e){
				$.ajax({
					url: 'api/?daten=hersteller',
					type: 'GET',
					dataType: 'JSON',
					beforeSend: function() {
						var loader = "<div id=\"list_loader\"><i class=\"fa fa-spinner fa-spin fa-3x fa-fw\"></i><span class=\"sr-only\">Loading...</span><br /><br /><span>Wird geladen...</span></div>";
						$("#herst_ol_list").html(loader);
					},
					success: function(data){
						if(data.status == "200") {
							var li = "";
							$.each(data.hersteller, function (index, value) {
								li += "<li class=\"gz_bs\" data-suche=\""+value.hersteller_name+"\" data-hid=\""+value.hersteller_id+"\"><img class=\"hersteller-logo\" src=\"img/pkwliste/hersteller/"+value.hersteller_id+".png\" alt=\""+value.hersteller_name+"\" />"+value.hersteller_name+"</li>";
							});
							$(".ergebnisse").hide();
							$(".suche-tab").show();	
							$("#baureihen_ol_list").hide();
							$("#generation_ol_list").hide();
							$("#sawl").show();
							$("#aswn").hide();
							$("#go_to_hsn_tsn").show();
							$(".hsn-tsn-image-container").show();
							$('.nav-tabs a[href="#pkw_suche"]').tab('show');
							$("#herst_ol_list").html(li).show();
							$(".pkwliste_suche_inp").removeClass().addClass("pkwliste_suche_inp hersteller");
							$(".pkwliste_suche_inp").attr('placeholder', 'Hersteller');
							$(".pkwliste_suche_inp").val('');
							$("#sft").show();
							$("#pkw_hsn_tsn").hide();
							$("#pkw_suche").show();
							$("#list_loader").remove();
						}
						else {
							console.log(data.nachricht);
						}
						
					}
				});
			});
			$('body').on('click','#tab_l_2', function(e){
				$("#pkw_suche").hide();
				$("#ajax_erg_ml").hide();
				$("#pkw_hsn_tsn").show();
				$("#pkw_e_hsn_tsn").html('').hide();
				$("#hsntab").val('');
				$("#tsntab").val('');
				$("#list_loader").remove();				
			});
			$('body').on('click','.gz_bs', function(e){
				var id_marke = $(this).data('hid');
				$.ajax({
					url: 'api/?daten=modelle&id='+id_marke,
					type: 'GET',
					dataType: 'JSON',
					beforeSend: function() {
						var loader = "<div id=\"list_loader\"><i class=\"fa fa-spinner fa-spin fa-3x fa-fw\"></i><span class=\"sr-only\">Loading...</span><br /><br /><span>Wird geladen...</span></div>";
						$("#herst_ol_list").html(loader);
					},
					success: function(data){
						if(data.status == "200") {
							var li = "";
							$.each(data.modelle, function (index, value) {
								li += "<li class=\"gz_gr\" data-mid=\""+value.modell_id+"\" data-suche=\""+value.modell_name+"\"><img class=\"hersteller-logo\" src=\"img/pkwliste/hersteller/"+value.hersteller_id+".png\" alt=\""+value.hersteller_name+"\" />"+value.modell_name+"</li>";
							});
							$("#baureihen_ol_list").html(li);
							$("#herst_ol_list").hide();
							$("#baureihen_ol_list").show();
							$("#sawl").hide();
							$("#aswn").show();
							$(".pkwliste_suche_inp").removeClass().addClass("pkwliste_suche_inp baureihe");
							$(".pkwliste_suche_inp").attr('placeholder', 'Modell');	
							$(".pkwliste_suche_inp").val('');
						}
						else {
							console.log(data.nachricht);
						}
					}
				});
			});
			$('body').on('click','.gz_gr', function(e){
				var id_modell = $(this).data('mid');
				$.ajax({
					url: 'api/?daten=fahrzeuge&id='+id_modell,
					type: 'GET',
					dataType: 'JSON',
					beforeSend: function() {
						var loader = "<div id=\"list_loader\"><i class=\"fa fa-spinner fa-spin fa-3x fa-fw\"></i><span class=\"sr-only\">Loading...</span><br /><br /><span>Wird geladen...</span></div>";
						$("#generation_ol_list").html(loader);
					},
					success: function(data){
						if(data.status == "200") {
							var tr = "";
							$.each(data.fahrzeuge, function (index, value) {
								if(index % 2 == 0) {
									var oeclass = "odd";
								} 
								else {
									var oeclass = "even";
								}
								if(value.fahrzeug_hubraum == null) {
									hubraum = "k.A.";
								}
								else {
									hubraum = value.fahrzeug_hubraum+"ccm";
								}
								if(value.fahrzeug_prod_monat_von == null || value.fahrzeug_prod_jahr_von == null) {
									modellstart = "??/????";
								}
								else {
									modellstart = value.fahrzeug_prod_monat_von+"/"+value.fahrzeug_prod_jahr_von;
								}
								if(value.fahrzeug_prod_monat_bis == null || value.fahrzeug_prod_jahr_bis == null) {
									modellende = "??/????";
								}
								else {
									modellende = value.fahrzeug_prod_monat_bis+"/"+value.fahrzeug_prod_jahr_bis;
								}
								tr += "<tr data-fid=\""+value.fahrzeug_id+"\" data-suche=\""+value.fahrzeug_name+"\" class=\""+oeclass+" ergbn-mdlw\">"
								+ "<td>"
								+ "<div class=\"checkbox checkbox-danger\">"
								+ "<input type=\"checkbox\" class=\"styled styled-primary\" value=\"\" />"
								+ "<label></label>"
								+ "</div>"
								+ "</td>"
								+ "<td>"+value.hersteller_name+" "+value.fahrzeug_name+"</td>"
								+ "<td>"+value.fahrzeug_typ+"</td>"
								+ "<td>"+value.fahrzeug_treibstoff+"</td>"
								+ "<td>"+value.fahrzeug_ps+"PS / "+value.fahrzeug_kw+"KW</td>"
								+ "<td class=\"hidden-xs\">"+hubraum+"</td>"
								+ "<td>"+modellstart+" - "+modellende+"</td>"
								+ "</tr>";
							});
							$("#ajax_ml").html(tr);
							$("#erg_hb").attr('src','img/pkwliste/hersteller/'+data.fahrzeuge[0].hersteller_id+'.png');
							$("#erg_mt").html(data.fahrzeuge[0].modell_name);
							$("#herst_ol_list").hide();
							$("#baureihen_ol_list").hide();
							$("#generation_ol_list").hide();
							$("#sft").hide();
							$("#aswn").hide();
							$(".pkwliste_suche_inp").val('');
							$("#ajax_erg_ml").show();
						}
						else {
							console.log(data.nachricht);
						}
					}
				});				
			});
		}		
	}
	core.init();	
});